/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Font;
import jclass.bwt.HeaderButton;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCComponent;
import jclass.bwt.JCHeader;
import jclass.bwt.JCLabel;
import jclass.bwt.JCMultiColumnData;
import jclass.bwt.JCMultiColumnInterface;
import jclass.bwt.JCScrolledWindow;
import jclass.bwt.LabelConverter;
import jclass.bwt.Viewport;
import jclass.util.JCSortInterface;
import jclass.util.JCVector;

public abstract class JCMultiColumnWindow
extends JCScrolledWindow
implements JCMultiColumnInterface,
JCActionListener {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    JCSortInterface sort_method;
    boolean column_label_sort = true;
    protected Viewport headerArea;
    protected JCHeader header;
    protected JCMultiColumnInterface comp;

    public JCMultiColumnWindow() {
        super(null, null);
    }

    public JCMultiColumnWindow(Applet applet, String string) {
        super(applet, string);
    }

    public JCHeader getHeader() {
        if (this.header == null) {
            this.setHeader(new JCHeader(null, this.applet, this.getName()));
        }
        return this.header;
    }

    public void setHeader(JCHeader jCHeader) {
        this.header = jCHeader;
        if (jCHeader == null) {
            if (this.headerArea != null) {
                this.remove(this.headerArea);
            }
            this.headerArea = null;
            return;
        }
        if (this.headerArea == null) {
            this.headerArea = new Viewport();
        }
        this.headerArea.add(jCHeader);
        jCHeader.setMultiColumnComponent((JCMultiColumnInterface)((Object)this.viewport));
        jCHeader.addActionListener(this);
        if (this.getPeer() != null) {
            this.addInternal(this.headerArea);
        }
    }

    public String[] getColumnLabels() {
        if (this.header == null) {
            return null;
        }
        JCComponent[] jCComponentArray = this.header.getLabels();
        String[] stringArray = new String[jCComponentArray.length];
        int n = 0;
        while (n < jCComponentArray.length) {
            Object object;
            stringArray[n] = jCComponentArray[n] instanceof JCLabel ? ((object = ((JCLabel)jCComponentArray[n]).getLabel()) != null ? object.toString() : "") : jCComponentArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    public void setColumnLabels(String[] stringArray) {
        this.setColumnLabels(new JCVector(stringArray));
    }

    public void setColumnLabels(JCVector jCVector) {
        if (this.header == null) {
            if (jCVector == null || jCVector.size() == 0) {
                return;
            }
            this.setHeader(new JCHeader(null, this.applet, this.getName()));
        }
        if (jCVector == null || jCVector.size() == 0) {
            this.setHeader(null);
            return;
        }
        this.header.setLabels(jCVector);
    }

    public void setColumnButtons(String[] stringArray) {
        this.setColumnButtons(new JCVector(stringArray));
    }

    public void setColumnButtons(JCVector jCVector) {
        if (this.header == null) {
            if (jCVector == null || jCVector.size() == 0) {
                return;
            }
            this.setHeader(new JCHeader(null, this.applet, this.getName()));
        }
        if (jCVector == null || jCVector.size() == 0) {
            this.setHeader(null);
            return;
        }
        this.header.setButtons(jCVector);
    }

    protected void setViewport(JCMultiColumnInterface jCMultiColumnInterface) {
        this.comp = jCMultiColumnInterface;
        this.viewport = (Component)((Object)jCMultiColumnInterface);
    }

    protected int reshapeHeader(int n, int n2, int n3) {
        int n4 = this.headerHeight();
        if (this.headerArea != null) {
            this.headerArea.reshape(n, n2, n3, n4);
        }
        return n4;
    }

    protected int headerHeight() {
        if (this.headerArea == null) {
            return 0;
        }
        return this.headerArea.preferredSize().height;
    }

    protected int headerWidth() {
        if (this.headerArea == null) {
            return 0;
        }
        return this.headerArea.preferredSize().width;
    }

    protected void reshapeViewport(int n, int n2, int n3, int n4) {
        if (this.headerArea != null) {
            n2 -= ((JCComponent)((Object)this.comp)).highlight;
        }
        super.reshapeViewport(n, n2, n3, n4);
    }

    protected int preferredHeight() {
        int n = super.preferredHeight();
        if (this.headerArea != null) {
            n += this.headerArea.preferredSize().height;
        }
        return n;
    }

    protected int getViewportWidth() {
        int n = super.getViewportWidth();
        if (this.headerArea != null) {
            n = Math.max(n, this.headerArea.preferredSize().width);
        }
        return n;
    }

    public synchronized void setFont(Font font) {
        if (this.getFont() != null && this.getFont().equals(font)) {
            return;
        }
        super.setFont(font);
        if (this.getPeer() == null) {
            return;
        }
        ((Component)((Object)this.comp)).setFont(font);
        if (this.header != null) {
            this.header.setFont(font);
        }
        this.layout();
    }

    public boolean getColumnLabelSort() {
        return this.column_label_sort;
    }

    public void setColumnLabelSort(boolean bl) {
        this.column_label_sort = bl;
    }

    public void setColumnLabelSortMethod(JCSortInterface jCSortInterface) {
        this.sort_method = jCSortInterface;
    }

    public JCSortInterface getColumnLabelSortMethod() {
        return this.sort_method;
    }

    public void sortByColumn(int n, JCSortInterface jCSortInterface) {
    }

    public void sortByColumn(int n, JCSortInterface jCSortInterface, int n2) {
    }

    public void addNotify() {
        super.addNotify();
        if (this.headerArea != null) {
            this.addInternal(this.headerArea);
            this.header.setMultiColumnComponent((JCMultiColumnInterface)((Object)this.viewport));
        }
    }

    protected void scrollHorizontal(JCAdjustmentEvent jCAdjustmentEvent, int n) {
        if (this.headerArea != null) {
            this.headerArea.scrollHorizontal(n);
        }
        super.scrollHorizontal(jCAdjustmentEvent, n);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (this.header == null || !this.getColumnLabelSort()) {
            return;
        }
        int n = 0;
        Component component = (Component)jCActionEvent.getSource();
        int n2 = this.header.getComponent(component);
        if (n2 < 0) {
            return;
        }
        if (component instanceof HeaderButton) {
            n = ((HeaderButton)component).direction;
        }
        this.sortByColumn(n2, this.sort_method, n);
        if (component instanceof HeaderButton) {
            ((HeaderButton)component).direction = n == 0 ? 1 : 0;
        }
    }

    public int[] getColumnWidths() {
        return this.comp.getColumnWidths();
    }

    public void setColumnWidths(int[] nArray) {
        if (this.header != null) {
            this.header.setColumnWidths(nArray);
        }
        this.comp.setColumnWidths(nArray);
    }

    public int getColumnWidth(int n) {
        return this.comp.getColumnWidth(n);
    }

    public void setColumnWidth(int n, int n2) {
        if (n2 < 0 && n2 != -998) {
            throw new IllegalArgumentException("invalid column width: " + n2);
        }
        if (this.header != null) {
            this.header.setColumnWidth(n, n2);
        }
        this.comp.setColumnWidth(n, n2);
    }

    public int getNumColumns() {
        return this.comp.getNumColumns();
    }

    public void setNumColumns(int n) {
        if (n < 0 && n != -998) {
            throw new IllegalArgumentException("invalid NumColumns: " + n);
        }
        this.comp.setNumColumns(n);
        if (this.header != null) {
            this.header.setNumColumns(n);
        }
        this.layout();
    }

    public int[] getColumnAlignments() {
        return this.comp.getColumnAlignments();
    }

    public int getColumnAlignment(int n) {
        return this.comp.getColumnAlignment(n);
    }

    public void setColumnAlignment(int n, int n2) {
        LabelConverter.checkAlignment(n2);
        this.comp.setColumnAlignment(n, n2);
    }

    public void setColumnLabelAlignment(int n, int n2) {
        LabelConverter.checkAlignment(n2);
        if (this.header != null) {
            this.header.setColumnAlignment(n, n2);
        }
    }

    public void setColumnAlignments(int[] nArray) {
        this.comp.setColumnAlignments(nArray);
    }

    public int getColumnPosition(int n) {
        return this.comp.getColumnPosition(n);
    }

    public int getColumnLeftMargin(int n) {
        return this.comp.getColumnLeftMargin(n);
    }

    public void setColumnLeftMargin(int n, int n2) {
        this.comp.setColumnLeftMargin(n, n2);
        if (this.header != null) {
            this.header.setColumnLeftMargin(n, n2);
        }
        this.layout();
    }

    public int getColumnRightMargin(int n) {
        return this.comp.getColumnRightMargin(n);
    }

    public void setColumnRightMargin(int n, int n2) {
        this.comp.setColumnRightMargin(n, n2);
        if (this.header != null) {
            this.header.setColumnRightMargin(n, n2);
        }
        this.layout();
    }

    public int calcWidth(int n) {
        return this.comp.calcWidth(n);
    }

    public JCMultiColumnData getMultiColumnData() {
        return this.comp.getMultiColumnData();
    }
}

